/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

import com.ibm.hwmca.base.rsf.util.RqsException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public final class RqService
implements FcsService {
    private static final String TRACE_MASKT = "XRSFRQST";
    private static final String TRACE_MASKF = "XRSFRQSF";
    private static final String TRACE_MASKD = "XRSFRQSD";
    private static FcsServer fcsServer = FcsServer.getFcsServer();
    public static FcsServiceId rqServiceId = new FcsServiceId("RqService", 1.0);
    private static RqService rql = new RqService();

    public static RqService getRqService() {
        return rql;
    }

    private RqService() {
        fcsServer.addLocalService(rqServiceId, this);
    }

    public String queryFileLocation(String filename, MachineId target) throws RqsException {
        Trace.trace(TRACE_MASKT, "-> RqService::queryFileLocation()");
        String result = this.query("find " + filename, target);
        Trace.trace(TRACE_MASKT, "<- RqService::queryFileLocation(): result=" + result);
        return result;
    }

    public String executeProgram(String pgmname, MachineId target) throws RqsException {
        Trace.trace(TRACE_MASKT, "-> RqService::executeProgram()");
        String result = this.query("exec " + pgmname, target);
        Trace.trace(TRACE_MASKT, "<- RqService::executeProgram(): result=" + result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String query(String queryString, MachineId target) throws RqsException {
        Trace.trace(TRACE_MASKT, "-> RqService::query()");
        Socket socket = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        String reply = null;
        String targetInfo = this.machineInfo(target);
        Trace.trace(TRACE_MASKD, "-> RqService.query: targetInfo=" + targetInfo);
        try {
            try {
                FcsConnection connection = FcsConnection.connect(target, rqServiceId);
                socket = connection.getSocket();
                oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                oos.writeObject(queryString);
                oos.flush();
                ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                reply = (String)ois.readObject();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "RqService.query Exception: " + e.getMessage());
                throw new RqsException(e.getMessage());
            }
            Object var10_10 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois == null) throw throwable;
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (oos != null) {
            oos.close();
        }
        if (ois != null) {
            ois.close();
        }
        Trace.trace(TRACE_MASKT, "<- RqService::query()");
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processConnection(FcsConnection connection) {
        block24: {
            MachineId sender2 = connection.getMachineId();
            String senderInfo = this.machineInfo(sender2);
            Trace.trace(TRACE_MASKT, "-> RqService.processConnection() " + senderInfo);
            ObjectInputStream ois = null;
            ObjectOutputStream oos = null;
            Socket socket = connection.getSocket();
            String request = null;
            String query = null;
            String parms = null;
            String response = null;
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            request = (String)ois.readObject();
            if (request == null) {
                throw new RqsException("No data received from sending machine");
            }
            request = request.trim();
            int commandSeparator = request.indexOf(" ");
            if (commandSeparator == -1) {
                query = request;
            } else {
                query = request.substring(0, commandSeparator);
                if (commandSeparator >= request.length()) {
                    parms = request.substring(commandSeparator);
                }
            }
            if (query.equalsIgnoreCase("find")) {
                try {
                    response = BaseFileControl.getFilePath(parms);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "RqService.processConnection() getFilePath exception");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else if (query.equalsIgnoreCase("exec")) {
                Trace.trace(TRACE_MASKF, "RqService.processConnection: exec not implemented yet");
            } else {
                Trace.trace(TRACE_MASKF, "RqService.processConnection: function not implemented \"" + request + "\"");
            }
            Trace.trace(TRACE_MASKD, "RqService.processConnection: response=" + response);
            oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            oos.writeObject(response);
            oos.flush();
            Object var14_14 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
                break block24;
            }
            catch (IOException ioe) {}
            break block24;
            {
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "RqService.processConnection Exception");
                    Trace.trace(TRACE_MASKF, e);
                    Object var14_15 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        if (ois != null) {
                            ois.close();
                        }
                        break block24;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RqService.processConnection()");
    }

    private String machineInfo(MachineId machine) {
        InetAddress[] nicAddresses = machine.getNicAddresses();
        return machine.getName() + "(" + nicAddresses[0] + ")";
    }
}

